/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.Interceptors;

import com.sun.corba.se.internal.Interceptors.PIORB;
import com.sun.corba.se.internal.core.ClientSubcontract;
import com.sun.corba.se.internal.core.IOR;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.IOP.CodecFactory;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ORBInitInfoPackage.InvalidName;
import org.omg.PortableInterceptor.PolicyFactory;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

public final class ORBInitInfoImpl
extends LocalObject
implements ORBInitInfo {
    private PIORB orb;
    private String[] args;
    private String orbId;
    private CodecFactory codecFactory;
    private int stage = 0;
    public static final int STAGE_PRE_INIT = 0;
    public static final int STAGE_POST_INIT = 1;
    public static final int STAGE_CLOSED = 2;
    private static final String MESSAGE_ORBINITINFO_INVALID = "ORBInitInfo object is only valid during ORB_init";

    public int allocate_slot_id() {
        this.checkStage();
        return this.orb.getPICurrent().allocateSlotId();
    }

    private void checkStage() {
        if (this.stage == 2) {
            throw new OBJECT_NOT_EXIST(MESSAGE_ORBINITINFO_INVALID);
        }
    }

    private void nullParam() throws BAD_PARAM {
        throw new BAD_PARAM(1398079689, CompletionStatus.COMPLETED_NO);
    }

    void setStage(int n2) {
        this.stage = n2;
    }

    public String orb_id() {
        this.checkStage();
        return this.orbId;
    }

    public String[] arguments() {
        this.checkStage();
        return this.args;
    }

    public CodecFactory codec_factory() {
        this.checkStage();
        return this.codecFactory;
    }

    public void add_client_request_interceptor(ClientRequestInterceptor clientRequestInterceptor) throws DuplicateName {
        this.checkStage();
        if (clientRequestInterceptor == null) {
            this.nullParam();
        }
        this.orb.register_interceptor(clientRequestInterceptor, 0);
    }

    public void add_ior_interceptor(IORInterceptor iORInterceptor) throws DuplicateName {
        this.checkStage();
        if (iORInterceptor == null) {
            this.nullParam();
        }
        this.orb.register_interceptor(iORInterceptor, 2);
    }

    public void register_policy_factory(int n2, PolicyFactory policyFactory) {
        this.checkStage();
        if (policyFactory == null) {
            this.nullParam();
        }
        this.orb.registerPolicyFactory(n2, policyFactory);
    }

    public void add_server_request_interceptor(ServerRequestInterceptor serverRequestInterceptor) throws DuplicateName {
        this.checkStage();
        if (serverRequestInterceptor == null) {
            this.nullParam();
        }
        this.orb.register_interceptor(serverRequestInterceptor, 1);
    }

    public Object resolve_initial_references(String string) throws InvalidName {
        this.checkStage();
        if (string == null) {
            this.nullParam();
        }
        if (this.stage == 0) {
            throw new BAD_INV_ORDER("Resolve Initial References cannot be called in pre_init", 1398080289, CompletionStatus.COMPLETED_NO);
        }
        Object object = null;
        try {
            object = this.orb.resolve_initial_references(string);
        }
        catch (org.omg.CORBA.ORBPackage.InvalidName invalidName) {
            throw new InvalidName();
        }
        return object;
    }

    public void register_initial_reference(String string, Object object) throws InvalidName {
        this.checkStage();
        if (string == null) {
            this.nullParam();
        }
        boolean bl2 = false;
        if (object == null) {
            bl2 = true;
        } else if (object instanceof ObjectImpl) {
            Delegate delegate = ((ObjectImpl)object)._get_delegate();
            ClientSubcontract clientSubcontract = (ClientSubcontract)((java.lang.Object)delegate);
            IOR iOR = clientSubcontract.marshal();
            bl2 = iOR.is_nil();
        }
        if (bl2) {
            throw new BAD_PARAM("register_initial_reference called with nil Object.", 1330446363, CompletionStatus.COMPLETED_NO);
        }
        try {
            this.orb.register_initial_reference(string, object);
        }
        catch (org.omg.CORBA.ORBPackage.InvalidName invalidName) {
            throw new InvalidName(invalidName.getMessage());
        }
    }

    ORBInitInfoImpl(PIORB pIORB, String[] stringArray, String string, CodecFactory codecFactory) {
        this.orb = pIORB;
        this.args = stringArray;
        this.orbId = string;
        this.codecFactory = codecFactory;
    }
}

